/*
 * Decompiled with CFR 0.152.
 */
package evilwan;

import evilwan.Foefel;
import evilwan.Goewie;
import evilwan.WSFilter;
import evilwan.WSPacket;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.table.TableModel;
import javax.xml.bind.DatatypeConverter;

public class WSGui
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private static String DEFAULT_FILTERCLASS = "evilwan.EvilFilter";
    private static String TOGGLE_BTN_START_INTERCEPT = "Intercept Websocket Messages Off";
    private static String TOGGLE_BTN_STOP_INTERCEPT = "Intercept Websocket Messages On";
    private JCheckBox _chk_index = null;
    private JCheckBox _chk_url = null;
    private JCheckBox _chk_dir = null;
    private JCheckBox _chk_time = null;
    private JCheckBox _chk_comment = null;
    private JCheckBox _chk_orgmsg = null;
    private JCheckBox _chk_edtmsg = null;
    private ButtonGroup _btngrp = null;
    private JRadioButton _rad_raw = null;
    private JRadioButton _rad_b64 = null;
    private JRadioButton _rad_hex = null;
    private Object _selected_fmt = null;
    private JButton _btn_save = null;
    private JTextField _txt_classname = null;
    private JButton _btn_intercept = null;
    private boolean _is_intercepting = false;
    private boolean _is_initialized = false;
    private JPanel _inttab = null;
    private JLabel _msglbl = null;
    private JButton _fwdbtn = null;
    private JToggleButton _togglebtn = null;
    private JTabbedPane _hextabpane = null;
    private Container _hextab = null;
    private JTable _jtab = null;
    private TableModel _model = null;
    private Field _data = null;
    private WSFilter _filter = null;

    public WSGui() {
        this.setLayout(new BoxLayout(this, 1));
        this.add(new JLabel("Select Output Fields:"));
        this.add(new JLabel(" "));
        this._chk_index = new JCheckBox("Index", true);
        this.add(this._chk_index);
        this._chk_url = new JCheckBox("URL", true);
        this.add(this._chk_url);
        this._chk_dir = new JCheckBox("Direction", true);
        this.add(this._chk_dir);
        this._chk_time = new JCheckBox("Time", false);
        this.add(this._chk_time);
        this._chk_comment = new JCheckBox("Comment", false);
        this.add(this._chk_comment);
        this._chk_orgmsg = new JCheckBox("Original Message", true);
        this.add(this._chk_orgmsg);
        this._chk_edtmsg = new JCheckBox("Edited Message", true);
        this.add(this._chk_edtmsg);
        this.add(new JLabel(" "));
        this.add(new JLabel("Select Output Field Format:"));
        this.add(new JLabel(" "));
        this._btngrp = new ButtonGroup();
        this._rad_raw = new JRadioButton("Raw");
        this._btngrp.add(this._rad_raw);
        this._rad_raw.addActionListener(this);
        this.add(this._rad_raw);
        this._rad_b64 = new JRadioButton("Base64", true);
        this._btngrp.add(this._rad_b64);
        this._rad_b64.addActionListener(this);
        this._selected_fmt = this._rad_b64;
        this.add(this._rad_b64);
        this._rad_hex = new JRadioButton("Hexadecimal");
        this._btngrp.add(this._rad_hex);
        this._rad_hex.addActionListener(this);
        this.add(this._rad_hex);
        this.add(new JLabel(" "));
        this._btn_save = new JButton("Save to file");
        this._btn_save.addActionListener(this);
        this.add(this._btn_save);
        this.add(new JLabel(" "));
        this.add(Box.createVerticalGlue());
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0));
        JLabel jLabel = new JLabel("Filter classname:");
        jPanel3.add(jLabel);
        this._txt_classname = new JTextField(DEFAULT_FILTERCLASS, 30);
        jPanel3.add(this._txt_classname);
        jPanel2.add(jPanel3);
        this._btn_intercept = new JButton(TOGGLE_BTN_START_INTERCEPT);
        this._btn_intercept.addActionListener(this);
        jPanel2.add(this._btn_intercept);
        jPanel.add(jPanel2);
        this.add(jPanel);
        this.add(Box.createVerticalGlue());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this._btn_save)) {
            this.saveToFile();
        } else if (actionEvent.getSource().equals(this._btn_intercept)) {
            this.toggleWSIntercept();
        } else if (actionEvent.getSource().equals(this._rad_raw)) {
            this._selected_fmt = this._rad_raw;
        } else if (actionEvent.getSource().equals(this._rad_b64)) {
            this._selected_fmt = this._rad_b64;
        } else if (actionEvent.getSource().equals(this._rad_hex)) {
            this._selected_fmt = this._rad_hex;
        }
    }

    private void toggleWSIntercept() {
        if (this._is_intercepting) {
            if (this._togglebtn.getText().indexOf(" on") >= 0) {
                this.doClick(this._togglebtn);
            }
            this._filter = null;
            this._btn_intercept.setText(TOGGLE_BTN_START_INTERCEPT);
        } else {
            try {
                if (!this._is_initialized) {
                    this.initEnvironment();
                    this._is_initialized = true;
                }
                if (this._filter == null) {
                    this._filter = (WSFilter)Class.forName(this._txt_classname.getText()).newInstance();
                }
                Goewie.selectNamedTabPane(this._hextabpane, "Hex");
                if (this._togglebtn.getText().indexOf(" on") < 0) {
                    this.doClick(this._togglebtn);
                }
            }
            catch (Exception exception) {
                System.out.println("caught: " + exception);
                exception.printStackTrace();
                System.exit(1);
            }
            this._btn_intercept.setText(TOGGLE_BTN_STOP_INTERCEPT);
        }
        this._is_intercepting = !this._is_intercepting;
    }

    private void saveToFile() {
        Object object = this.analyzeBurpEnvironment();
        JFileChooser jFileChooser = new JFileChooser();
        int n = jFileChooser.showSaveDialog(null);
        if (n == 0) {
            this.dumpWSMessages(jFileChooser.getSelectedFile(), object);
        }
    }

    private Object analyzeBurpEnvironment() {
        Object object = null;
        try {
            object = Foefel.findWSTable();
        }
        catch (Exception exception) {
            System.out.println("## caught: " + exception);
            exception.printStackTrace();
            System.exit(1);
        }
        WSPacket.init(object);
        return object;
    }

    private void dumpBar(FileWriter fileWriter, byte[] byArray) throws Exception {
        if (this._selected_fmt == null || byArray == null) {
            return;
        }
        if (this._selected_fmt.equals(this._rad_raw)) {
            fileWriter.write("<![CDATA[");
            fileWriter.write(new String(byArray));
            fileWriter.write("]]>");
        } else if (this._selected_fmt.equals(this._rad_b64)) {
            fileWriter.write("<![CDATA[");
            fileWriter.write(DatatypeConverter.printBase64Binary((byte[])byArray));
            fileWriter.write("]]>");
        } else if (this._selected_fmt.equals(this._rad_hex)) {
            fileWriter.write(new BigInteger(1, byArray).toString(16));
        } else {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpWSMessages(File file, Object object) {
        if (file == null) {
            return;
        }
        OutputStreamWriter outputStreamWriter = null;
        try {
            Collection collection = (Collection)object;
            outputStreamWriter = new FileWriter(file);
            outputStreamWriter.write("<?xml version=\"1.0\"?>");
            outputStreamWriter.write("<wspackets>");
            int n = 0;
            for (Object e : collection) {
                String string;
                WSPacket wSPacket = new WSPacket(e);
                outputStreamWriter.write("<packet>");
                if (this._chk_index.isSelected()) {
                    outputStreamWriter.write("<index>" + (n + 1) + "</index>");
                }
                if (this._chk_url.isSelected()) {
                    string = wSPacket.getURL();
                    outputStreamWriter.write("<url>");
                    if (string != null) {
                        outputStreamWriter.write(string);
                    }
                    outputStreamWriter.write("</url>");
                }
                if (this._chk_dir.isSelected()) {
                    outputStreamWriter.write("<direction>" + (wSPacket.getClientToServer() ? "C2S" : "S2C") + "</direction>");
                }
                if (this._chk_time.isSelected()) {
                    outputStreamWriter.write("<time>" + wSPacket.getTimestamp() + "</time>");
                }
                if (this._chk_comment.isSelected()) {
                    outputStreamWriter.write("<comment>");
                    string = wSPacket.getComment();
                    if (string != null) {
                        outputStreamWriter.write("<![CDATA[");
                        outputStreamWriter.write(string);
                        outputStreamWriter.write("]]>");
                    }
                    outputStreamWriter.write("</comment>");
                }
                if (this._chk_orgmsg.isSelected()) {
                    outputStreamWriter.write("<original_msg>");
                    this.dumpBar((FileWriter)outputStreamWriter, wSPacket.getOriginalMessage());
                    outputStreamWriter.write("</original_msg>");
                }
                if (this._chk_edtmsg.isSelected()) {
                    outputStreamWriter.write("<edited_msg>");
                    this.dumpBar((FileWriter)outputStreamWriter, wSPacket.getEditedMessage());
                    outputStreamWriter.write("</edited_msg>");
                }
                outputStreamWriter.write("</packet>");
                ++n;
            }
            outputStreamWriter.write("</wspackets>");
            outputStreamWriter.close();
            outputStreamWriter = null;
        }
        catch (Exception exception) {
            System.out.println("## caught: " + exception);
            exception.printStackTrace();
        }
        finally {
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                    outputStreamWriter = null;
                }
                catch (Exception exception) {}
            }
        }
    }

    private void initEnvironment() throws Exception {
        Frame[] frameArray = Frame.getFrames();
        for (int i = 0; i < frameArray.length; ++i) {
            this._inttab = (JPanel)Goewie.findNamedTabPane(frameArray[i], "Intercept");
            if (this._inttab != null) break;
        }
        this._msglbl = Goewie.findMessageLabel(this._inttab);
        this._fwdbtn = (JButton)Goewie.findNamedButton(this._inttab, "Forward");
        this._fwdbtn.addPropertyChangeListener(this);
        this._togglebtn = (JToggleButton)Goewie.findNamedButton(this._inttab, "Intercept");
        this._hextabpane = Goewie.findTabbedPane(this._inttab, "Hex");
        this._hextab = (Container)Goewie.findNamedTabPane(this._hextabpane, "Hex");
        this._jtab = Goewie.findJTable(this._hextab);
        this._model = this._jtab.getModel();
        this.getDataField();
    }

    private void getDataField() throws Exception {
        Class<?> clazz = this._model.getClass();
        Field[] fieldArray = clazz.getDeclaredFields();
        this._data = null;
        for (int i = 0; i < fieldArray.length; ++i) {
            fieldArray[i].setAccessible(true);
            if (!fieldArray[i].getType().equals(byte[].class)) continue;
            this._data = fieldArray[i];
            return;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        boolean bl;
        String string;
        if (this._is_intercepting && (string = propertyChangeEvent.getPropertyName()).equals("enabled") && (bl = ((Boolean)propertyChangeEvent.getNewValue()).booleanValue())) {
            String string2 = this._msglbl.getText();
            if (string2 == null || !string2.startsWith("WebSockets")) {
                this.doClick(this._fwdbtn);
                return;
            }
            this.filterWS(string2);
            this.doClick(this._fwdbtn);
        }
    }

    private void filterWS(String string) {
        try {
            boolean bl = string.indexOf(" from ") < 0;
            int n = string.lastIndexOf(32);
            byte[] byArray = this.getBytes();
            byte[] byArray2 = this._filter.doFilter(bl, string.substring(n + 1), byArray);
            if (byArray2 != null) {
                this.setBytes(byArray2);
            }
        }
        catch (Exception exception) {
            System.out.println("caught: " + exception);
            exception.printStackTrace();
        }
    }

    private byte[] getBytes() throws Exception {
        return (byte[])this._data.get(this._model);
    }

    private void setBytes(byte[] byArray) throws Exception {
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        this._data.set(this._model, byArray2);
    }

    private void doClick(final AbstractButton abstractButton) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                abstractButton.doClick();
            }
        });
    }
}

